
#|

FASTLOAD.LSP compiles specified files or all files in the SOURCE, MAKETIME and RUNTIME
directories which need compiling as determined by file dates of the .LSP and .FSL files (a file needs compiling if the .LSP is newer than the .FSL). Puts resulting FSL files in FSLFILES, MAKETIME or RUNTIME directories, respectively. Then loads files in the SOURCE and MAKETIME directories in preparation for making workspace.

Files in the source and maketime directories are used in constructing the workspace file. The maketime files are used to "make vista workspace", whereas the source files are formed into the workspace by the maketime files. Runtime files, on the other hand, are used during the installation of ViSta each time it is run to customize the environment suitably for the ensuing run. Thus, maketime and source files do not need to be used after installation, whereas runtime files must be used on each run. Thus, runtime files must be distributed to the users, whereas source and maketime files do not need to be.

The files are not only grouped in a specific manner, but they are then loaded in a specific order. DO NOT CHANGE THE GROUPING OR ORDERING.  The groups of files are as follows:

MAKE FILES 
are the files that are involved in the make process. All of these files take effect while they are being loaded, and are needed to construct the workspace. They are all compilable.

SOURCE FILES
are the files that form the main body of the code. They are all written so that they have no effect until ViSta is running. Thus, they can all be compiled and linked together into a workspace. This greatly improves the startup time, since they never have to be loaded when the user is using ViSta.

RUNTIME FILES
are files whose actions take effect as they are being loaded, and whose effects depend on the details of the installation configuration. they can be compiled but must be loaded at runtime

UNCOMPILABLE FILES
are files in the source directory that are loadable but wont compile

SPECIAL FILES
are those that when loaded take action emmediately. they are all in runtime directory and can be compiled as runtime files, but cant be loaded with runtime files

WORKSPACE FILES
are all of the files involved in making the workspace. a change in one or more of these files means the workspace must be recomputed

|#

    ;  (listeners)

(setf *source-files* 
      (list  

;container files

       "contain1" "contain2" "listener"

;iconmap and workmap files

       "iconobj1" "iconobj2" "iconobj3" "iconobj4" "iconobj5"
       "workmap0" "workmap1" "workmap2" "workmap3" "workmap4" "workmap5" 
       "toolbar"  "toolbar2" "funcname" "funcmenu" "workbar"

;system object files

       "systmob1" "systslot" "systmob2" "systmob3" "systmob4"
       "graphelp" "guidemap" "guidemp2" "hyperlog"

;statistical enhancement files
 
       "function" "functreg" "functin2" "funcstat" "generic"  

;text window files

       "display1" "display2" "display3" "display4" 
       "reportw"  "message1" "message2" "message3" "message4"
             
;data object files

       "dataobj0" "dataobj1" "datatype" "dataslot" 
       "dataobj2" "dataobj3" "dataobj4" "dataobj5" "dataobj6" 
       "datasmry" "datarept" "toolmenu" "datasim"  "dataset"

;model, transformation and plugin object files

       "modelobj" "modelob1" "tranobj1" "tranobj2" "tranobj3" "plugin"
	"arithmetic" ; file for arithmetic transformations PV 21-4-2003

; viva files

       "parcil"   "viva" 

; datasheet files - note that dashobj0 is last until i get code cleaned, then first
; due to fact that methods/funtions in dashobj0 must override out-of-date
; code in other files.

       "dashobj1" "dashobj2" "dashobj3" "dashobj4" "dashobj5" "dashobj6"
       "namelist" "overlay1" "overlay2" 
       "dashover" "brovrly0" "brovrly1" "brovrly2" "dashobj0"
       "nameovrl" "buttons"  "dissobj"
       
;visualization files

       "datavis"  "datavis1" "datavis2" "datavis3" "datavis4" "datavis5" "crosstab"
       "scatter1" "scatter2" "scatter3" 
	"scatter4" ;PV 10-4-2003
	"quantour" "scatmat"  "spinplot" 
       "boxplot1" "boxplot2" "boxplot3" "qplotobj" "histogrm" "histfrq1" 
       "histfrq2" "histfrq3" "mosaic1"  "mosaic2"  "mosaic3"  "bargraph" 
       "tourplot" "visuals"  "sprdplt1" "sprdplt2" "sprdsize" 
       "plots000" "plots001" "plots002" "plots003" "plots004" "plots005" "views001"  

;Pedro's missing data files

       "missd0"   "missd1"   "missd2"   "missd3"   "missd4"   "missd5"  
       "missd6"   "missd7"   "missd8"   "missd9"   "missd10"  "vismiss"
       "repmiss"  
       #+msdos      "cursorsw" 
       #+macintosh  "cursorsm"
       #+X11        "file-sel"

;PV Pedro's pdf files 10-4-03 

        "histofrqpdf" "writepdf" "spmatrixpdf" "Spinpdf" "Scatpdf" "savenpp"
        "otherplots"    "mosaicpdf"  "graphpdf" "boxpdf.lsp"
	"myparscolr2"

;core analysis files

;       "codeload" no longer needed since all files now loaded here or as plugin

;installaton files

       "logoobj1" "logoobj2" "logoobj3"  "logoobj4" "clock" ;"listener" 
       "install1" "display5"  "desktop"  "vista1"   "vista2" 

;former runtime files for core model objects

       "regress"  "regmob"   "rg0robst"  "rg1simpl" "rg1supr1" "rg2supr2" 
       "rg3iters" "rg4splot" "rg5plots"  "rg6plots" "rg7lsmtr" "rg8cntrl" 
       "rg9help"  "regdemo"  "anovamob"  "anovamoc" "nway"     "anovavis" 
       "anovavs2" "unimob"   "unimob1"   "unimob2"

;former pedro runtime files

       "boxcox" "dummyvar" "foldedpower" "searchreplace" 
       ))

;make files

      (setf *make-files* 
            (list "maker" "fastload" "defvar" "defun0" "defun1" "defun2" "defun3" 
                  "defpref0" "defpref1" "paths001" "develtools" "verbose" 
                  "startman"))

;uncompilable and special files

      (setf *uncompileable-files* (list "install2" "vinstall"))
      (setf *special-files* (list "vista"  "config"))

; runtime files


      (setf *runtime-files* 
            (list "vismenu1" "vismenu2" "vismenu3" "vismenu4" ;"vismenu5"
                  "graphic0" "graphic1" "dialogs" "paths000"
                  ))

(setf *compileable-workspace-files* (combine *make-files* *source-files*))
(setf *load-files* *source-files*)
(setf *workspace-files* (combine *compileable-workspace-files* *uncompileable-files*))
(setf *base-files* (combine *source-files* *make-files*  *runtime-files* *special-files*))
(setf *all-files* (combine *base-files* *uncompileable-files*))

(setf *compile-after-loading-needed* nil)
(setf *rebuild-after-compile-needed* nil)
(setf *compiled-any-files?* nil)



#|
 | compile but dont load (because of side effects) maketime files.
 | if any needed compiling then we must reload all files.
 |#

(defun compile-changed-vista-sources ()
"main entry to compiler system from make-vista function. this function compiles (to provide a time stamp) but does not load (because of side effects) all maketime files. it then compiles but does not load all source and runtime files."
  (let* ((make-path (strcat *default-path* "maketime" separator))
         (fsl-path  (strcat *default-path* "fslfiles" separator)))
    (please-wait (format nil "Compile ViSta: Compiling MakeTime Files")
                 :title "Compile ViSta" :pause 30)
    (compile-load-workspace-files *make-files* make-path make-path
                                  :compile t :load nil)
    (please-wait (format nil "Compile ViSta: Source Files to Compile") 
                 :title "Compile ViSta" :pause 30)
    
    (load-changed-program-files t *base-files* t)
    ))

(defun load-all-source-files (&key (compile))
  (load-changed-program-files t *load-files* compile)
  )

(defun load-program-files (&optional pref-path)
;(print "load-program-files")
  (if *fast-start* 
      (load-changed-program-files nil *load-files* nil nil pref-path)
      (load-changed-program-files   t *load-files* nil nil pref-path)))

(defun load-dependent-program-files (file-list)
  (load-changed-program-files t file-list t t))

(defun load-uncompileable-files ()
  (let* ((path (if *default-path* *default-path* (get-working-directory) )))
  (mapcar #'(lambda (file) 
              (copy-file (strcat path "source\\" file)
                         (strcat path "fslfiles\\" file))
              (load (strcat path  "fslfiles\\" file)))
          *uncompileable-files*)))



(defun compile-load-workspace-files (file-list lsp-path fsl-path &key (compile t) (load t))
"Args: FILE-LIST LSP-PATH &OPTIONAL FSL-PATH &KEY (COMPILE T) (LOAD T)
Compiles each file in FILE-LIST. Files are in LSP-PATH. Results go to FSL-PATH (FSLFILES if omitted). Does not compile or load if COMPILE or LOAD are nil."
  (let* ((file.fsl) (file.lsp) (date.fsl) (date.lsp) (load-needed)
         (load-verb *load-verbose*) (compiler-needed t) (file)
         (path (if *default-path* *default-path* (get-working-directory)))
         )
    (unless fsl-path (setf fsl-path (strcat path "fslfiles\\")))
    (please-wait (format nil "Make ViSta:  Loading Files") :pause 0 :title "Make ViSta")
    (setf *compile-msg-flag* *show-make-steps?*)
    (setf *load-verbose* *show-make-steps?*)
    (setf *compiler-loaded* nil)
   ; (mapcar #'(lambda (file)  ))
    (dotimes (i (length file-list))
             (setf file (select file-list i))
             (setf file.fsl (strcat fsl-path file ".fsl"))
             (setf file.lsp (strcat lsp-path file ".lsp"))
             (cond 
               ((and (probe-file file.lsp)
                     (probe-file file.fsl))
                (setf date.lsp (file-write-date file.lsp))
                (setf date.fsl (file-write-date file.fsl))
                (when (and compile (< date.fsl date.lsp))
                      (setf *rebuild-after-compile-needed* t)
                      (when compiler-needed
                            (listeners)
                            (get-compiler-system)
                            (debug-mode t)
                            (setf compiler-needed nil))
                      (please-wait (format nil "Compile ViSta: Compiling ~a"file.lsp) :title "Compile ViSta")
                      (protected-compile-file file.lsp file.fsl 
                                              *compile-msg-flag* *compiler-loaded*)
                      (please-wait 
                       (format nil "Compile ViSta: Loading Files") 
                       :pause 30
                       :title "Compile ViSta"))
                (when (and (not compile) (< date.fsl date.lsp))
                      (please-wait 
                       (format nil  "Compile ViSta: Compiling ~a CANCELLED!" file.lsp) 
                       :pause 30 :title "Compile ViSta"))
                (when load 
                      (please-wait 
                       (format nil  "Compile ViSta: Loading File ~a" file.lsp) 
                       :pause 0 :title "Compile ViSta")
                      (load file.fsl)))
               ((probe-file file.lsp)
                (please-wait 
                 (format nil "Compile ViSta: Loading Files - No .FSL File - ~a~%" file.fsl)
                 :pause 30 :title "Compile ViSta")
                (when compile 
                      (protected-compile-file file.lsp file.fsl
                                              *compile-msg-flag* *compiler-loaded*)
                      (please-wait 
                       (format nil "Compile ViSta: Loading Files") 
                       :pause 30
                       :title "Compile ViSta"))
                (load file.lsp))
               ((probe-file file.fsl)
                (cond
                  (compile (format t "; STOPPING:  MISSING .LSP FILE ~a~%" file.lsp))
                  (load (load file.fsl))))
               (t 
                (format t 
                        "; FATALITY:  MISSING FILE ~a~%; FATALITY:  MISSING FILE ~a~%"
                        file.fsl file.lsp)
                (please-wait 
                 (format nil "Compile ViSta: Fatal Error   - No .FSL or .LSP File - ~a" file.lsp)
                 :show-time 4 :title "Compile ViSta")
                (top-level)
                )))
    ;file-list
    (setf *load-verbose* nil)
    t))

(defun protected-compile-file (file.lsp file.fsl msg-flag load-compiler)
  (unless load-compiler (get-compiler-system))
  (please-wait (format nil "Compile ViSta: Compiling ~a"file.lsp) :title "Compile ViSta")
  (let* ((result 
          (multiple-value-list
           (ignore-errors 
            (compile-file file.lsp :output-file file.fsl :print t :verbose t)))))
    (when (> (length result) 1)
          (please-wait (format nil "Compile ViSta: Compiler Error. Using Source.") 
                       :pause 30 :title "Compile ViSta"))))
     
       


(defun show-compile-msg ()
  ;(xlispstat-window)
  (nodebug)
  (please-wait (format nil "Compile ViSta: Searching Source Files") :pause 20 :title "Compile ViSta")
  t)
  
(defun show-compilation ()
  (setf *compile-msg-flag* t)
  ;(xlispstat-window)
  (terpri))

(setf *compile-msg-flag* nil)
(setf *compiling* nil)
(setf *compiler-loaded* nil)

(defun load-changed-program-files (all file-list &optional compile dependent pref-path)
"Args: ALL FILE-LIST COMPILE DEPENDENT PREF-PATH
For those files in FILE-LIST, load most recent source/*.lsp or fslfiles/*.fsl files. If ALL is NIL, only load those whose date is more recent than the date on the XLisp.wks file, otherwise load all. Optionally COMPILE .lsp files (default is value of *COMPILING*). DEPENDENT has no effect. PREF-PATH specifies preference file path (needed during phase creating distribution module, when all paths are locally defined.)"
  ;(double-dribble (strcat *default-path* "compile" (format nil "~d" *run-number*) ".log"))
  (hidemainwindow)
  (setf *source-files-length* 0)
  (setf *source-files-number* 0)
  (flet ((test-this-file (test-file-list best-date)
          ;Exits with either name and date of new best file, or nil
          (let ((date)(best-file)(test-file))
            (setf test-file (strcat *default-path* (first test-file-list) separator 
                               (second test-file-list) (third test-file-list)))
            (setf short-test-file (strcat (first test-file-list) separator 
                               (second test-file-list) (third test-file-list)))
            (when (probe-file test-file)
                  (setf date (file-write-date test-file))
                ;  (format t "; TestFile: ~a BestFile: ~a TestDate: ~a BestDate:~a~2%" short-test-file best-file date best-date)
                  (when (> date best-date) 
                        (setf best-date date)
                        (setf best-file test-file-list)))
            (if best-file
                (list best-file best-date)
                nil)))
         )
    (let* ((XLisp.wks   (strcat *default-path* "XLisp.wks"))
           (date.wks (if (probe-file "XLisp.wks")
                         (file-write-date "XLisp.wks")
                         0))
           (debug-state *debug-mode*)
           (best-date) (bytes 0)
           (best-file)(filenum 0)
           (showing)
           (compile-msg-flag))
           (if (not compile) (setf compile *compiling*))
      (nodebug)
      (setf *file-verbose* nil)
      (when compile ;send *please-wait* :new-message 
           (please-wait (format nil "Compile ViSta: Searching Source Files") :pause 20 :title "Compile ViSta"))
      (mapcar #'(lambda (file)
                  (setf best-file nil)
                  (setf best-date (if all 0 date.wks))
                  (mapcar #'(lambda (dir ext)
                              (setf file-being-tested (list dir file ext))
                              (setf result (test-this-file file-being-tested best-date))
                              (when result
                                    (setf best-file (first result))
                                    (setf best-date (second result)))
                              )
                          (list "fslfiles" "source")
                          (list ".fsl"     ".lsp")
                          )
                  (when best-file
                        (cond 
                          (compile
                           (setf compile-msg-flag t)
                           
                           (when (equal (subseq (reverse (third best-file)) 0 4) "psl.")
                                 (compile-vista-source-file best-file)
                                 (please-wait (format nil 
                                     "Compile ViSta: Searching Source  Files") 
                                              :pause 30 :title "Compile ViSta")
                                 (setf *compile-after-loading-needed* nil)
                                 (setf *rebuild-after-compile-needed* t)))
                          (t
                           (setf best-file-str 
                                 (strcat *default-path* (first best-file) separator
                                         (second best-file) (third best-file)))
                         ;  (please-wait (format nil "Compile ViSta: Loading Files - ~a" 
                         ;                       (second best-file)) :title "Compile ViSta")
                         ;  (format t "; loaded ~a~%" (strcat (first best-file) separator
                         ;                (second best-file) (third best-file)))
                           (with-open-file (stream best-file-str)
                                           (load best-file-str))
                           (setf bytes (+ bytes (get-file-length best-file-str)))
                           (setf filenum (1+ filenum))
                           (please-wait (format nil 
                             "Make ViSta: Loading File ~d - ~a~%            Total Bytes = ~d"
                              filenum best-file-str bytes))
                           ))))
              file-list)
      (setf *source-files-length* bytes)
      (setf *source-files-number* filenum)
      (when compile 
            (please-wait (format nil "Compile ViSta: Searching RunTime") :pause 20 :title "Compile ViSta")
            (mapcar #'(lambda (file)
                        (compile-vista-runtime-file file))
                    *runtime-files*))
      (when compile
            (please-wait (format nil "Compile ViSta: Searching Special") :pause 20 :title "Compile ViSta")
            (mapcar #'(lambda (file)
                        (compile-vista-runtime-file file))
                    *special-files*))
      (when compile
            (please-wait (format nil "Compile ViSta: Searching Make") :pause 20 :title "Compile ViSta")
            (mapcar #'(lambda (file)
                        (compile-vista-make-file file))
                    *make-files*))
      (when compile
            (please-wait (format nil "Compile ViSta: Compiler Phase Completed Successfully~%ReRun ViSta to Make ViSta WorkSpace Image File") :pause 60 :title "Compile ViSta"))
      (if debug-state (debug))
      (setf *file-verbose* nil)
      )))

